struct VS_INPUT 
{
	float4 Position   : POSITION;
	int4   BatchIndex : BLENDINDICES;
	half2  TexCoord	  : TEXCOORD0;
};

#ifndef MAX_BATCH_SIZE
	#define MAX_BATCH_SIZE 16
#endif

row_major float4x4 arrWorldTx[MAX_BATCH_SIZE] : register(c[0]);

float4x4 ViewProj;

sampler2D Tex0 : register( s0 );

void vs_main( 
	in VS_INPUT In,
	out float4 Position : POSITION,
	out float2 TexCoord : TEXCOORD0) 
{
	TexCoord = In.TexCoord;
	Position = mul( mul( In.Position, arrWorldTx[In.BatchIndex.x] ), ViewProj );
}

float4 ps_main(
	float2 TexCoord : TEXCOORD0
	) : COLOR
{
    return tex2D(Tex0, TexCoord);
}

technique ZPrePass
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_main();
	}
}

float4 TFactor;
bool bAlphaBlend;
bool bAlphaTest;

float4 ps_shadow(
	float2 TexCoord : TEXCOORD0
	) : COLOR
{
	if(bAlphaBlend)
	{
		return float4(TFactor.rgb, tex2D(Tex0, TexCoord).a);
	}
	else if (bAlphaTest)
	{
		return float4(TFactor.rgb, tex2D(Tex0, TexCoord).a);
	}
	else
	{
		return TFactor;
	}
}

technique OffShadow
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_shadow();
	}
}
